/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.plant;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;
import technology.rocketjump.undermount.rendering.RenderMode;

public class PlantEntityAssetDictionaryProvider
implements Provider<PlantEntityAssetDictionary> {
    private final EntityAssetTypeDictionary entityAssetTypeDictionary;
    private final TextureAtlasRepository textureAtlasRepository;
    private final PlantSpeciesDictionary plantSpeciesDictionary;

    @Inject
    public PlantEntityAssetDictionaryProvider(EntityAssetTypeDictionary entityAssetTypeDictionary, TextureAtlasRepository textureAtlasRepository, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.entityAssetTypeDictionary = entityAssetTypeDictionary;
        this.textureAtlasRepository = textureAtlasRepository;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
    }

    @Override
    public PlantEntityAssetDictionary get() {
        TextureAtlas diffuseTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.DIFFUSE_ENTITIES);
        TextureAtlas normalTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.NORMAL_ENTITIES);
        FileHandle entityDefinitionsFile = Gdx.files.internal("assets/definitions/entityAssets/plantEntityAssets.json");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List assetList = (List)objectMapper.readValue(entityDefinitionsFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, PlantEntityAsset.class));
            for (PlantEntityAsset asset : assetList) {
                for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, diffuseTextureAtlas, RenderMode.DIFFUSE);
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, normalTextureAtlas, RenderMode.NORMALS);
                }
            }
            return new PlantEntityAssetDictionary(assetList, this.entityAssetTypeDictionary, this.plantSpeciesDictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

